package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BUtil;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (04/06/07)
 */
public class P06B22T00DAO {

	static private P06B22T00DAO instance = null;

	public static P06B22T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B22T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B22T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return void
    * @throws SQLException
    */
	public void insert(P06B22T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-insert");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

        lstm.setString(1,obj.getTipo().toUpperCase());
	    lstm.setString(2,obj.getNExpediente().toUpperCase());
	    lstm.setString(3,obj.getIdentificador().toUpperCase());
	    lstm.setString(4,obj.getTipo1().toUpperCase());
	    lstm.setString(5,obj.getRazSoc().toUpperCase());
	    lstm.setString(6,obj.getNombre().toUpperCase());
	    lstm.setString(7,obj.getApe1().toUpperCase());
	    lstm.setString(8,obj.getApe2().toUpperCase());
	    lstm.setString(9,obj.getDomici().toUpperCase());
	    lstm.setString(10,obj.getCodmun().toUpperCase());
	    lstm.setString(11,obj.getLocali().toUpperCase());
	    lstm.setString(12,obj.getCodpro().toUpperCase());
	    lstm.setString(13,obj.getCodpst().toUpperCase());
	    lstm.setString(14,obj.getFecAlta().toUpperCase());
	    lstm.setString(15,obj.getFecBaja().toUpperCase());
		if(obj.getParticipa().equals("")){
    		lstm.setString(16,null);
    	}else{
    		lstm.setDouble(16, Double.parseDouble(obj.getParticipa()));
    	}
	    lstm.setString(17,obj.getIdRep().toUpperCase());
	    lstm.setString(18,obj.getNomRep().toUpperCase());

    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B22T00DAO-insert");
	}

	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList selectAllByExp(String expediente, String tipo) throws Exception{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectAllByExp");
		ArrayList lista = new ArrayList();
		P06B22T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	obj = new P06B22T00Datatype();
	        	//obj.setNExpediente(cont+"");
	        	obj.setTipo(lrst.getString(P06BTablas.P06B_P06B22_TIPO));
			    obj.setNExpediente(lrst.getString(P06BTablas.P06B_P06B22_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
			    obj.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
			    obj.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
			    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
			    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
			    obj.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
			    obj.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
			    obj.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
			    obj.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));

	        	//cont++;
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectAllByExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}

	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws SQLException
	* @throws Exception
    */
	public ArrayList<P06B22T00Datatype> selectInformeComunicarDGSFP2() throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00Datatype-selectInformeComunicarDGSFP2");
		ArrayList<P06B22T00Datatype> informeComunicarDGSFP2PDF = new ArrayList<P06B22T00Datatype>();
		P06B22T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_LISTADO2;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lrst = lstm.executeQuery();
            int indLinea = 0;
	        while(lrst.next()) {
	        	obj = new P06B22T00Datatype();
			    obj.setNExpediente(lrst.getString(1));
			    obj.setIdentificador(lrst.getString(2));
			    obj.setTipo1(lrst.getString(3));
			    obj.setRazSoc(lrst.getString(4));
			    obj.setNombre(lrst.getString(5));
			    obj.setApe1(lrst.getString(6));
			    obj.setApe2(lrst.getString(7));
			    obj.setFecAlta(lrst.getString(8));
			    obj.setFecBaja(lrst.getString(9));
			    obj.setParticipa(lrst.getString(10));
	        	informeComunicarDGSFP2PDF.add(indLinea, obj);
        		indLinea++;
	        }
	        P06BLog.send(2,this, "Fin P06B64T00Datatype-selectInformeComunicarDGSFP2");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return informeComunicarDGSFP2PDF;
	}


	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList selectSociosIncorporacionDEC(String expediente, String tipo, int nEjerIncorporarDEC) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectSociosIncorporacionDEC");
		ArrayList lista = new ArrayList();
		P06B22T00Datatype obj22 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACION_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lstm.setString(3,tipo);
        	lstm.setString(4,expediente.toUpperCase());
        	lstm.setString(5,tipo);
        	lstm.setString(6,expediente.toUpperCase());
        	lstm.setInt(7,nEjerIncorporarDEC);
        	lstm.setString(8,tipo);
        	lstm.setString(9,tipo);
        	lstm.setString(10,expediente.toUpperCase());
        	lstm.setString(11,expediente.toUpperCase());
        	lstm.setInt(12,nEjerIncorporarDEC);
        	lstm.setString(13,tipo);
        	lstm.setString(14,expediente.toUpperCase());
        	lstm.setString(15,tipo);
        	lstm.setString(16,tipo);
        	lstm.setString(17,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");
	        	boolean moverCamposSistema = false;
	        	boolean moverCamposTramitagune = false;
	        	boolean bHayDatosSistema = false;
	        	if (operacion==0){
	        		moverCamposSistema = true;
	        		bHayDatosSistema = true;
	        	}else if (operacion==1){
	        		moverCamposTramitagune = true;
	        	}else if (operacion==2){
	        		moverCamposSistema = true;
	        		moverCamposTramitagune = true;
	        		bHayDatosSistema = true;
	        	}

	        	obj22 = new P06B22T00Datatype();
	        	obj22.setOperacion(operacion);
	        	if (moverCamposSistema==true){
				    obj22.setNExpediente(expediente.toUpperCase());
		        	obj22.setTipo(tipo);
				    obj22.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
				    obj22.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
				    obj22.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
				    obj22.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
				    obj22.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
				    obj22.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
				    obj22.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
				    obj22.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
				    obj22.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
				    obj22.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
				    obj22.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
				    obj22.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
				    obj22.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
				    obj22.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));
	        	}

	        	if (moverCamposTramitagune==true){
				    obj22.setNExpediente(expediente.toUpperCase());
				    obj22.setTipo(tipo);
				    obj22.setIdentificador(lrst.getString(P06BTablas.P06B_P06B33_IDENTIFICADOR));
				    obj22.setTipo1(lrst.getString(P06BTablas.P06B_P06B33_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B33_TIPO1));
				    obj22.setRazSoc(lrst.getString(P06BTablas.P06B_P06B33_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B33_RAZSOC));
				    obj22.setNombre(lrst.getString(P06BTablas.P06B_P06B33_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B33_NOMBRE));
				    obj22.setApe1(lrst.getString(P06BTablas.P06B_P06B33_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B33_APE1));
				    obj22.setApe2(lrst.getString(P06BTablas.P06B_P06B33_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B33_APE2));
				    obj22.setFecAlta(lrst.getString(P06BTablas.P06B_P06B33_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B33_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setParticipa(lrst.getString(P06BTablas.P06B_P06B33_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B33_PARTICIPA));

	        	}
//			    obj22.setAprobado(0);

			    if (bHayDatosSistema==true){
			    	P06B22T00Datatype datos22Originales = new P06B22T00Datatype();
			    	datos22Originales.setNExpediente(expediente.toUpperCase());
			    	datos22Originales.setTipo(tipo);
			    	datos22Originales.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
			    	datos22Originales.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
			    	datos22Originales.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
			    	datos22Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
			    	datos22Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
			    	datos22Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
			    	datos22Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
			    	datos22Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
			    	datos22Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
			    	datos22Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
			    	datos22Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
			    	datos22Originales.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    	datos22Originales.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    	datos22Originales.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
			    	datos22Originales.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
			    	datos22Originales.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));
			    	obj22.setDatos22Originales(datos22Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//				    obj33.setParticipa(obj33.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//						obj33.setFecAlta(P06BFecha.fechaEuFromFecha(obj33.getFecAlta()));
//					}

	        	//cont++;
	        	lista.add(obj22);
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectSociosIncorporacionDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}




	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList selectSociosIncorporacionModTramitagune(String expediente, String tipo, int nCorrelAtencionPeticionEnRevision) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectSociosIncorporacionModTramitagune");
		ArrayList lista = new ArrayList();
		P06B22T00Datatype obj22 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(3,tipo);
        	lstm.setString(4,expediente.toUpperCase());
//        	lstm.setString(5,tipo);
//        	lstm.setString(6,expediente.toUpperCase());
//        	lstm.setInt(7,nCorrelAtencionPeticionEnRevision);
//        	lstm.setString(8,tipo);
//        	lstm.setString(9,tipo);
//        	lstm.setString(10,expediente.toUpperCase());
//        	lstm.setString(11,expediente.toUpperCase());
        	lstm.setInt(5,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(6,tipo);
        	lstm.setString(7,expediente.toUpperCase());
        	lstm.setString(8,tipo);
        	lstm.setInt(9,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(10,tipo);
        	lstm.setString(11,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");

	        	obj22 = new P06B22T00Datatype();
			    obj22.setNExpediente(expediente.toUpperCase());
	        	obj22.setOperacion(operacion);
//			    obj22.setAprobado(0);
	        	if (operacion==0){
		        	obj22.setTipo(tipo);
				    obj22.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
				    obj22.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
				    obj22.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
				    obj22.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
				    obj22.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
				    obj22.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
				    obj22.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
				    obj22.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
				    obj22.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
				    obj22.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
				    obj22.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
				    obj22.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
				    obj22.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
				    obj22.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));
	        	}

	        	if (operacion==1 || operacion==2){
				    obj22.setTipo(tipo);
				    obj22.setIdentificador(lrst.getString(P06BTablas.P06B_P06B72_SC_IDENTIFICADOR));
				    obj22.setTipo1(lrst.getString(P06BTablas.P06B_P06B72_SC_TIPO1));
				    obj22.setRazSoc(lrst.getString(P06BTablas.P06B_P06B72_SC_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_RAZSOC));
				    obj22.setNombre(lrst.getString(P06BTablas.P06B_P06B72_SC_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_NOMBRE));
				    obj22.setApe1(lrst.getString(P06BTablas.P06B_P06B72_SC_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_APE1));
				    obj22.setApe2(lrst.getString(P06BTablas.P06B_P06B72_SC_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_APE2));
				    obj22.setFecAlta(lrst.getString(P06BTablas.P06B_P06B72_SC_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B72_SC_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj22.setParticipa(lrst.getString(P06BTablas.P06B_P06B72_SC_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_PARTICIPA));
				    obj22.setIdRep(lrst.getString(P06BTablas.P06B_P06B72_SC_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_IDREP));
				    obj22.setNomRep(lrst.getString(P06BTablas.P06B_P06B72_SC_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B72_SC_NOMREP));
				    if (operacion==2){
				    	//Inicializar campos no aportados por Tramitagune para que no se pierdan
					    obj22.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
					    obj22.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
					    obj22.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
					    obj22.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
					    obj22.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
					    obj22.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    }
	        	}

			    if (operacion==0 || operacion==2){
			    	P06B22T00Datatype datos22Originales = new P06B22T00Datatype();
			    	datos22Originales.setNExpediente(expediente.toUpperCase());
			    	datos22Originales.setTipo(tipo);
			    	datos22Originales.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
			    	datos22Originales.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
			    	datos22Originales.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
			    	datos22Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
			    	datos22Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
			    	datos22Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
			    	datos22Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
			    	datos22Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
			    	datos22Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
			    	datos22Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
			    	datos22Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
			    	datos22Originales.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    	datos22Originales.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    	datos22Originales.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
			    	datos22Originales.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
			    	datos22Originales.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));
			    	obj22.setDatos22Originales(datos22Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//				    obj33.setParticipa(obj33.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//						obj33.setFecAlta(P06BFecha.fechaEuFromFecha(obj33.getFecAlta()));
//					}

	        	//cont++;
	        	lista.add(obj22);
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectSociosIncorporacionModTramitagune");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}


	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public int selectEjercicioIncorporarDEC(String expediente) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectEjercicioIncorporarDEC");
		int ejercicioIncorporarDEC = -1;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTEJERCICIO_INCORPORAR_DEC;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	ejercicioIncorporarDEC = Integer.parseInt(lrst.getString("MINEJER"));
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectEjercicioIncorporarDEC");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return ejercicioIncorporarDEC;
	}

	/**
    */
	public int selectCorrelAtencionPeticionEnRevision(String expediente) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectCorrelAtencionPeticionEnRevision");
		int correlAtencionPeticionEnRevision = -1;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTATENCIONPETICIONENREVISION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	correlAtencionPeticionEnRevision = Integer.parseInt(lrst.getString("CORRELATENCPETIC"));
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectCorrelAtencionPeticionEnRevision");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return correlAtencionPeticionEnRevision;
	}

	/**
    * Elimina todos los socios asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos socios eliminamos
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @throws SQLException
    */
	public void deleteAllByExp(String exp, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-deleteAllByExp");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEALL_BYEXP;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B22T00DAO-deleteAllByExp");
	}



	/**
    * Elimina todos los socios asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos socios eliminamos
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @throws SQLException
    */
	public void deleteByExpId(String exp, String tipo, String id) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-deleteByExpId");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEBYEXPID;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,tipo);
    	lstm.setString(3,id);
    	lstm.executeUpdate();
    	if(lstm!=null) lstm.close();
    	if(lconConexion!=null)lconConexion.close();
        P06BLog.send(2,this, "Fin P06B22T00DAO-deleteByExpId");
	}


	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @param identificador: cif o nif
    * @param idioma
    * @return objeto que cumple los parametros, o null si no lo encuentra
	* @throws Exception
    */
	public P06B22T00Datatype selectByPK(String expediente, String tipo, String identificador, String idioma) throws Exception{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectByPK");
		P06B22T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lstm.setString(3,identificador.toUpperCase());
        	lrst = lstm.executeQuery();
	        if(lrst.next()) {
	        	obj = new P06B22T00Datatype();
	        	obj.setTipo(lrst.getString(P06BTablas.P06B_P06B22_TIPO));
			    obj.setNExpediente(lrst.getString(P06BTablas.P06B_P06B22_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B22_IDENTIFICADOR));
			    obj.setTipo1(lrst.getString(P06BTablas.P06B_P06B22_TIPO1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_TIPO1));
			    obj.setRazSoc(lrst.getString(P06BTablas.P06B_P06B22_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B22_RAZSOC));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B22_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMBRE));
			    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B22_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE1));
			    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B22_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B22_APE2));
			    obj.setDomici(lrst.getString(P06BTablas.P06B_P06B22_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_DOMICI));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B22_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B22_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B22_LOCALI));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B22_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPRO));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B22_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B22_CODPST));
			    obj.setFecAlta(lrst.getString(P06BTablas.P06B_P06B22_FECALTA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECALTA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setFecBaja(lrst.getString(P06BTablas.P06B_P06B22_FECBAJA)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B22_FECBAJA),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setParticipa(lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B22_PARTICIPA));
			    obj.setIdRep(lrst.getString(P06BTablas.P06B_P06B22_IDREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_IDREP));
			    obj.setNomRep(lrst.getString(P06BTablas.P06B_P06B22_NOMREP)==null?"":lrst.getString(P06BTablas.P06B_P06B22_NOMREP));

			    //Ojo con los Double, Cambio los puntos por comas
			    obj.setParticipa(obj.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
				if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
					obj.setFecAlta(P06BFecha.fechaEuFromFecha(obj.getFecAlta()));
					obj.setFecBaja(P06BFecha.fechaEuFromFecha(obj.getFecBaja()));
				}
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectByPK");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return obj;
	}


	/**
    * Obtiene el nmero de objetos del expediente y tipo indicados
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return int con el nmero de registros encontrados
	* @throws Exception
    */
	public int selectNumObj(String expediente, String tipo) throws Exception{
		P06BLog.send(2,this, "Inicio P06B22T00DAO-selectNumObj");
		int numRegsEncontrados = 0;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_NUMREGS;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();

        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,tipo);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	numRegsEncontrados = lrst.getInt(1);
	        }
	        P06BLog.send(2,this, "Fin P06B22T00DAO-selectNumObj");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return numRegsEncontrados;
	}



	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B22T00_TABLA +
		"("+
		P06BTablas.P06B_P06B22_TIPO + "," +
		P06BTablas.P06B_P06B22_NUMEXP + "," +
		P06BTablas.P06B_P06B22_IDENTIFICADOR + "," +
		P06BTablas.P06B_P06B22_TIPO1 + "," +
		P06BTablas.P06B_P06B22_RAZSOC + "," +
		P06BTablas.P06B_P06B22_NOMBRE + "," +
		P06BTablas.P06B_P06B22_APE1 + "," +
		P06BTablas.P06B_P06B22_APE2 + "," +
		P06BTablas.P06B_P06B22_DOMICI + "," +
		P06BTablas.P06B_P06B22_CODMUN + "," +
		P06BTablas.P06B_P06B22_LOCALI + "," +
		P06BTablas.P06B_P06B22_CODPRO + "," +
		P06BTablas.P06B_P06B22_CODPST + "," +
		P06BTablas.P06B_P06B22_FECALTA + "," +
		P06BTablas.P06B_P06B22_FECBAJA + "," +
		P06BTablas.P06B_P06B22_PARTICIPA +
		"," + P06BTablas.P06B_P06B22_IDREP + "," +
		P06BTablas.P06B_P06B22_NOMREP +
		")"+
		" VALUES(TO_NUMBER(?),?,?,?,?,?,?,?,?,TO_NUMBER(?),TO_NUMBER(?),TO_NUMBER(?),?,TO_DATE(?,'dd/MM/yyyy'),TO_DATE(?,'dd/MM/yyyy'),?" +
		",?,?" +
		")";

	private static String SELECTALL_BY_EXP =
		"SELECT "
		+ P06BTablas.P06B_P06B22_TIPO + ", "
		+ P06BTablas.P06B_P06B22_NUMEXP + ", "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ P06BTablas.P06B_P06B22_APE1 + ", "
		+ P06BTablas.P06B_P06B22_APE2 + ", "
		+ P06BTablas.P06B_P06B22_DOMICI + ", "
		+ P06BTablas.P06B_P06B22_CODMUN + ", "
		+ P06BTablas.P06B_P06B22_LOCALI + ", "
		+ P06BTablas.P06B_P06B22_CODPRO + ", "
		+ P06BTablas.P06B_P06B22_CODPST + ", "
		+ P06BTablas.P06B_P06B22_FECALTA + ", "
		+ P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(" + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA +
		", " + P06BTablas.P06B_P06B22_IDREP + ", "
		+ P06BTablas.P06B_P06B22_NOMREP +
		" FROM " + P06BTablas.P06B_P06B22T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B22_NUMEXP + "= ?"
			+ " AND " + P06BTablas.P06B_P06B22_TIPO + "= TO_NUMBER(?)"
		+" ORDER BY " + P06BTablas.P06B_P06B22_IDENTIFICADOR ;

	private static String SELECT_LISTADO2 =
		"SELECT "
		+ P06BTablas.P06B_P06B22_NUMEXP + ", "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ P06BTablas.P06B_P06B22_APE1 + ", "
		+ P06BTablas.P06B_P06B22_APE2 + ", "
		+ "TO_CHAR(" + P06BTablas.P06B_P06B22_FECALTA + ", 'DD/MM/YYYY'), "
		+ "TO_CHAR(" + P06BTablas.P06B_P06B22_FECBAJA + ", 'DD/MM/YYYY'), "
		+ "TRIM(TO_CHAR(" + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.'))" +
		" FROM " + P06BTablas.P06B_P06B22T00_TABLA + ", " + P06BTablas.P06B_P06B20T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B22_NUMEXP + "=" + P06BTablas.P06B_P06B20_NUMEXP
		+ " AND "+ P06BTablas.P06B_P06B20_ESTADO + " in ('A','S','R','V') "
		+ " AND (" + P06BTablas.P06B_P06B22_PARTICIPA + "> 9 OR " + P06BTablas.P06B_P06B22_PARTICIPA + " is null)"
		+ " ORDER BY " + P06BTablas.P06B_P06B22_NUMEXP + ", " + P06BTablas.P06B_P06B22_IDENTIFICADOR;

	private static String SELECTALL_INCORPORACION_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B22_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B22_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECALTA + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B22_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMREP + ", "
		+ "S." + P06BTablas.P06B_P06B33_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B33_TIPO1 + ", "
		+ "S." + P06BTablas.P06B_P06B33_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B33_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B33_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B33_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B33_FECALTA + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B33_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B33_PARTICIPA
		+ " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B33T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B33_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B22_NUMEXP + "=S." + P06BTablas.P06B_P06B33_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B22_TIPO + "=S." + P06BTablas.P06B_P06B33_TIPO
		+ " AND A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B33_IDENTIFICADOR
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B22_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B22_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECALTA + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B22_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMREP + ", "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B22_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B33_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B33T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B33_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_TIPO + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B22_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B22_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B22_IDENTIFICADOR
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B33_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B33_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B33_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B33_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B33_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B33_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B33_FECALTA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B33_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B33_PARTICIPA
		+ " FROM " + P06BTablas.P06B_P06B33T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B33_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B33T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B33_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_EJERCICIO + "=?"
		+ " AND S." + P06BTablas.P06B_P06B33_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B22_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B33_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B33_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B33_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B33_IDENTIFICADOR
		+ " ORDER BY 1 DESC,2";

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B22_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B22_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECALTA + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B22_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMREP + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_TIPO1 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_FECALTA + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B72_SC_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B72_SC_PARTICIPA
		+ ", " + "S." + P06BTablas.P06B_P06B72_SC_IDREP + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_NOMREP
		+ " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B72T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B22_NUMEXP + "=S." + P06BTablas.P06B_P06B72_SC_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B22_TIPO + "=S." + P06BTablas.P06B_P06B72_SC_TIPO
		+ " AND A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_FECALTA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B72_SC_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B72_SC_PARTICIPA
		+ ", " + "A." + P06BTablas.P06B_P06B72_SC_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_NOMREP
		+ " FROM " + P06BTablas.P06B_P06B72T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B72T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B22_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR
		+ " ORDER BY 1 DESC,2";

	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXPOLD =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B22_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B22_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECALTA + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B22_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMREP + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_TIPO1 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_FECALTA + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B72_SC_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B72_SC_PARTICIPA
		+ ", " + "S." + P06BTablas.P06B_P06B72_SC_IDREP + ", "
		+ "S." + P06BTablas.P06B_P06B72_SC_NOMREP
		+ " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B72T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B22_NUMEXP + "=S." + P06BTablas.P06B_P06B72_SC_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B22_TIPO + "=S." + P06BTablas.P06B_P06B72_SC_TIPO
		+ " AND A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + "=S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B22_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B22_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B22_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B22_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECALTA + ", "
		+ "A." + P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B22_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B22_NOMREP + ", "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL"
		+ ", NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B22_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B72T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B22_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B22_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B22_IDENTIFICADOR
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_TIPO1 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_FECALTA + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B72_SC_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B72_SC_PARTICIPA
		+ ", " + "A." + P06BTablas.P06B_P06B72_SC_IDREP + ", "
		+ "A." + P06BTablas.P06B_P06B72_SC_NOMREP
		+ " FROM " + P06BTablas.P06B_P06B72T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B72T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + " FROM " + P06BTablas.P06B_P06B22T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B22_NUMEXP + "=?"
		+ " AND T1." + P06BTablas.P06B_P06B22_TIPO + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B72_SC_TIPO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B72_SC_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR + "=A." + P06BTablas.P06B_P06B72_SC_IDENTIFICADOR
		+ " ORDER BY 1 DESC,2";

	private static String SELECTEJERCICIO_INCORPORAR_DEC =
		"SELECT NVL(MIN(P06B32_EJERCICIO),-1) AS MINEJER FROM P06B20T00_CORREDORES, P06B32T00_DEC_MODELO01Y02 "
		+ " WHERE P06B32_NUMEXP = ? AND P06B20_NUMEXP = P06B32_NUMEXP AND (P06B20_ULTEJERINCORPORADO IS NULL OR P06B32_EJERCICIO > P06B20_ULTEJERINCORPORADO)";

	private static String SELECTATENCIONPETICIONENREVISION =
		"SELECT NVL(MIN(P06B64_AP_CORRELATENCPETIC), -1) AS CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION, P06B70T00_CORREDORES, P06B20T00_CORREDORES "
		+ " WHERE P06B20_NUMEXP = ? AND P06B70_CO_NUMEXP = P06B20_NUMEXP AND P06B64_AP_CORRELATENCPETIC = P06B70_CO_CORRELATENCPETIC AND (P06B20_ATENCPETICINCORPORADA IS NULL OR P06B70_CO_CORRELATENCPETIC > P06B20_ATENCPETICINCORPORADA) AND P06B64_AP_FINALIZADA = 1";

	private static String DELETEALL_BYEXP =
		"DELETE FROM "+ P06BTablas.P06B_P06B22T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B22_NUMEXP + " = ?"
			+ " AND " + P06BTablas.P06B_P06B22_TIPO + "= TO_NUMBER(?)";


	private static String DELETEBYEXPID =
		"DELETE FROM "+ P06BTablas.P06B_P06B22T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B22_NUMEXP + " = ?"
			+ " AND " + P06BTablas.P06B_P06B22_TIPO + "= TO_NUMBER(?)"
			+ " AND " + P06BTablas.P06B_P06B22_IDENTIFICADOR + "= ?";


	private static String SELECTALL_BY_PK =
		"SELECT "
		+ P06BTablas.P06B_P06B22_TIPO + ", "
		+ P06BTablas.P06B_P06B22_NUMEXP + ", "
		+ P06BTablas.P06B_P06B22_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B22_TIPO1 + ", "
		+ P06BTablas.P06B_P06B22_RAZSOC + ", "
		+ P06BTablas.P06B_P06B22_NOMBRE + ", "
		+ P06BTablas.P06B_P06B22_APE1 + ", "
		+ P06BTablas.P06B_P06B22_APE2 + ", "
		+ P06BTablas.P06B_P06B22_DOMICI + ", "
		+ P06BTablas.P06B_P06B22_CODMUN + ", "
		+ P06BTablas.P06B_P06B22_LOCALI + ", "
		+ P06BTablas.P06B_P06B22_CODPRO + ", "
		+ P06BTablas.P06B_P06B22_CODPST + ", "
		+ P06BTablas.P06B_P06B22_FECALTA + ", "
		+ P06BTablas.P06B_P06B22_FECBAJA + ", "
		+ "TRIM(TO_CHAR(" + P06BTablas.P06B_P06B22_PARTICIPA + ",'999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B22_PARTICIPA +
		", " + P06BTablas.P06B_P06B22_IDREP + ", "
		+ P06BTablas.P06B_P06B22_NOMREP +
		" FROM " + P06BTablas.P06B_P06B22T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B22_NUMEXP + "= ?"
			+ " AND " + P06BTablas.P06B_P06B22_TIPO + "= TO_NUMBER(?)"
			+ " AND " + P06BTablas.P06B_P06B22_IDENTIFICADOR + "= ?";

	private static String SELECT_NUMREGS =
		"SELECT COUNT(*) "
		+" FROM " + P06BTablas.P06B_P06B22T00_TABLA
		+" WHERE " + P06BTablas.P06B_P06B22_NUMEXP + "= ? "
			+ " AND " + P06BTablas.P06B_P06B22_TIPO + "= TO_NUMBER(?)";


}
